LoadPlugin("/Applications/4Media 2D to 3D Video Converter.app/Contents/MacOS/libmWaterMark.dylib")
function CalibrateAudio(clip c, int channels, int samplepersec, string bitspersample)
{
	(channels <= 0) ? Eval("""
			aclip = c.KillAudio()
		""") : Eval("""
			aclip = NeedAudio(c, channels, samplepersec, bitspersample)
		""")

	return AudioDubEx(c, aclip)
}

function NeedAudio(clip c, int channels, int samplepersec, string bitspersample)
{
# 2.58 can use this for effient
#		haschannels = c.AudioChannels()
#		(haschannels > 0) ? Eval("""
#			aclip = CalibrateChannels(c, channels, samplepersec, bitspersample)
#		""") : Eval("""
#			aclip = BlankClip(c, audio_rate=samplepersec, channels=channels, sample_type=bitspersample)
#		""")

# 2.57 use this
	aclip = CalibrateChannels(c, channels, samplepersec, bitspersample)
	
	return aclip
}

function CalibrateChannels(clip c, int channels, int samplepersec, string bitspersample)
{
	haschannels = c.AudioChannels()
#2.58 can use this for accurate
#	silent = BlankClip(c, audio_rate=samplepersec, channels=1, sample_type=bitspersample).KillVideo()

# 2.57 use this
	silent = Tone(length=c.FrameCount/c.FrameRate, samplerate=samplepersec, channels=1, type="silence")

	ch = 1 #0
	(haschannels >= ch) ? Eval("""
	ar = ArrayCreate(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ArrayCreate(silent)
	""")

	ch = ch+1	#1
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")
	
	ch = ch+1 #2
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")
	
	ch = ch+1 #3
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")

	ch = ch+1 #4
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")

	ch = ch+1 #5
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")

	ch = ch+1 #6
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")

	ch = ch+1 #7
	(haschannels >= ch) ? Eval("""
	ar = ar.ArrayInsert(GetChannel(c, ch).SSRC(samplepersec))
	""") : Eval("""
	ar = ar.ArrayInsert(silent)
	""")
	
	# Prepare the desired audio clip	
	(channels == 1) ? Eval("""
	aclip = ar.ArrayGet(0)
	""") : NOP
	
	(channels == 2) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1))
	""") : NOP
	
	(channels == 3) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2))
	""") : NOP

	(channels == 4) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3))
	""") : NOP

	(channels == 5) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4))
	""") : NOP

	(channels == 6) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5))
	""") : NOP

	(channels == 7) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5), ar.ArrayGet(6))
	""") : NOP

	(channels >= 8) ? Eval("""
	aclip = MergeChannels(ar.ArrayGet(0), ar.ArrayGet(1), ar.ArrayGet(2), ar.ArrayGet(3), ar.ArrayGet(4), ar.ArrayGet(5), ar.ArrayGet(6), ar.ArrayGet(7))
	""") : NOP

	return aclip
}
